<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\PaysController;
use App\Http\Controllers\API\UserController;

use App\Http\Controllers\API\VilleController;
use App\Http\Controllers\API\ContentController;
use App\Http\Controllers\API\MissionController;
use App\Http\Controllers\API\SponsorController;
use App\Http\Controllers\API\ActualiteController;
use App\Http\Controllers\API\PublicationController;
use App\Http\Controllers\API\PresentationController;
use App\Http\Controllers\API\ReglementationController;
use App\Http\Controllers\API\SlideController;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\API\VideoController;
use App\Http\Controllers\API\InterviewController;

use App\Http\Controllers\API\CommunicationController;

use App\Http\Controllers\API\StatController;

use App\Http\Controllers\API\DomaineController;
use App\Http\Controllers\API\SubscriberController;
Route::apiResource('domaines', DomaineController::class);

Route::apiResource('subscribers', SubscriberController::class);
Route::apiResource('stats', StatController::class);


// // Routes pour les actualités
// Route::apiResource('actualites', ActualiteController::class);

// // Route pour servir les images des actualités
// Route::get('/images_actualite/{filename}', function ($filename) {
//     $path = storage_path('app/public/images_actualite/' . $filename);

//     if (!file_exists($path)) {
//         abort(404);
//     }
//     return response()->file($path);
// });



// Routes CRUD pour les actualités
Route::apiResource('actualites', ActualiteController::class);

// Route personnalisée pour la recherche par slug
Route::get('actualites/slug/{slug}', [ActualiteController::class, 'show']);

// Route pour servir les images
Route::get('/storage/images_actualite/{filename}', function ($filename) {
    $path = storage_path('app/public/images_actualite/' . $filename);
    
    if (!file_exists($path)) {
        \Log::warning("Image not found: " . $filename);
        abort(404);
    }
    
    return response()->file($path);
})->where('filename', '.*');


// Route::apiResource('actualites', ActualiteController::class);

// // Route pour servir les images directement (facultatif, mais peut être utile)
// Route::get('/images_actualite/{filename}', function ($filename) {
//     $path = storage_path('app/public/images_actualite/' . $filename);

//     if (!file_exists($path)) {
//         \Log::warning("Image not found: " . $filename); // Log l'image manquante
//         abort(404);
//     }
//     return response()->file($path);
    
// });



// Routes pour la gestion des interviews
Route::prefix('interviews')->group(function () {
    Route::get('/', [InterviewController::class, 'index']); // Récupérer toutes les interviews
    Route::post('/', [InterviewController::class, 'store']); // Ajouter une nouvelle interview
    Route::get('/{slug}', [InterviewController::class, 'show']); // Afficher une interview par son slug
    Route::put('/{id}', [InterviewController::class, 'update']); // Mettre à jour une interview
    Route::delete('/{id}', [InterviewController::class, 'destroy']); // Supprimer une interview
});

// Route pour servir l'image principale des interviews
Route::get('/interviews/image/{filename}', function ($filename) {
    $path = storage_path('app/public/interviews/' . $filename);
    if (!file_exists($path)) {
        abort(404);
    }
    return response()->file($path);
});



Route::apiResource('videos', VideoController::class);
// Routes API pour les slides
Route::apiResource('slides', SlideController::class);

// Route pour servir les images des slides
Route::get('/images_slides/{filename}', function ($filename) {
    $path = storage_path('app/public/images_slides/' . $filename);

    if (!file_exists($path)) {
        abort(404);
    }

    return response()->file($path);
});
Route::apiResource('presentations', PresentationController::class);




Route::post('login', [AuthController::class, 'login'])->name('login');

Route::middleware('auth:sanctum')->post('logout', [AuthController::class, 'logout']);







Route::apiResource('sponsors', SponsorController::class);

// Route pour servir les images des sponsors
Route::get('/images_sponsor/{filename}', function ($filename) {
    $path = storage_path('app/public/images_sponsor/' . $filename);

    if (!file_exists($path)) {
        abort(404);
    }
    return response()->file($path);
});


//Route::get('users', [UserController::class, 'index']); // Pour obtenir tous les utilisateurs
Route::middleware('auth:sanctum')->get('/me', [AuthController::class, 'me']);
// Routes publiques pour l'authentification
Route::post('/register/usager', [AuthController::class, 'registerUsager']);
Route::post('/register/partenaire', [AuthController::class, 'registerPartenaire']);

Route::post('/password/forgot', [AuthController::class, 'forgotPassword']);
Route::post('/password/reset', [AuthController::class, 'resetPassword']);




Route::apiResource('publications', PublicationController::class);
// Route pour servir les photos
Route::get('/images_publication/{filename}', function ($filename) {
    $path = storage_path('app/public/photos/' . $filename);

    if (!file_exists($path)) {
        abort(404);
    }
    return response()->file($path);
});

// Route pour servir les documents
Route::get('/documents_publication/{filename}', function ($filename) {
    $path = storage_path('app/public/documents/' . $filename);
    if (!file_exists($path)) {
        abort(404);
    }
    return response()->file($path);
});







Route::apiResource('communications', CommunicationController::class);

// Routes pour servir les fichiers
Route::get('/images_communication/{filename}', function ($filename) {
    $path = storage_path('app/public/photos/' . $filename);
    if (!file_exists($path)) abort(404);
    return response()->file($path);
});

Route::get('/documents_communication/{filename}', function ($filename) {
    $path = storage_path('app/public/documents/' . $filename);
    if (!file_exists($path)) abort(404);
    return response()->file($path);
});



Route::apiResource('reglementations', ReglementationController::class);

Route::get('/images_reglementation/{filename}', function ($filename) {
    $path = storage_path('app/public/images/' . $filename);

    if (!file_exists($path)) {
        abort(404);
    }

    return response()->file($path);
});

Route::get('/documents_reglementation/{filename}', function ($filename) {
    $path = storage_path('app/public/documents/' . $filename);

    if (!file_exists($path)) {
        abort(404);
    }

    return response()->file($path);
});

// Route publique pour récupérer toutes les villes
Route::get('villes', [VilleController::class, 'index']); // Récupérer toutes les villes

// Route publique pour récupérer les villes par pays
Route::get('pays/{paysId}/villes', [VilleController::class, 'getVillesByPays']);

// Routes protégées par middleware 'auth:sanctum'
Route::middleware(['auth:sanctum'])->group(function () {
    Route::post('villes', [VilleController::class, 'store']); // Créer une nouvelle ville
    Route::get('villes/{id}', [VilleController::class, 'show']); // Récupérer une ville par ID
    Route::put('villes/{id}', [VilleController::class, 'update']); // Mettre à jour une ville par ID
    Route::delete('villes/{id}', [VilleController::class, 'destroy']); // Supprimer une ville par ID
});

// Route publique pour récupérer la liste des pays
Route::get('/pays', [PaysController::class, 'index']); // Récupérer la liste des pays

// Routes protégées par middleware 'auth:sanctum'
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/pays', [PaysController::class, 'store']);     // Créer un nouveau pays
    Route::get('/pays/{id}', [PaysController::class, 'show']);  // Récupérer un pays par ID
    Route::put('/pays/{id}', [PaysController::class, 'update']); // Mettre à jour un pays
    Route::delete('/pays/{id}', [PaysController::class, 'destroy']); // Supprimer un pays
});


Route::apiResource('missions', MissionController::class);


Route::get('contents', [ContentController::class, 'index']); // Récupérer tous les contenus
Route::get('contents/{type}', [ContentController::class, 'getContentsByType']); // Récupérer les contenus par type


// Les routes suivantes sont protégées par le middleware auth:sanctum
Route::middleware('auth:sanctum')->group(function () {
    Route::post('contents', [ContentController::class, 'store']); // Créer un contenu
    Route::put('contents/{id}', [ContentController::class, 'update']); // Mettre à jour un contenu
    Route::delete('contents/{id}', [ContentController::class, 'destroy']); // Supprimer un contenu
});

Route::apiResource('slides', SlideController::class);


Route::get('/users', [UserController::class, 'index']); // Récupérer tous les utilisateurs
Route::get('/users/type/{type}', [UserController::class, 'getByType']); // Récupérer les utilisateurs par type
