<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Stat;

class StatSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $stats = [
            [
                'label' => 'Total des dépôts et consignations (millions FCFA)',
                'value' => 1564,
            ],
            [
                'label' => 'Provisions pour risques et charges (millions FCFA)',
                'value' => 40,
            ],
            [
                'label' => 'Total des fonds transféré (millions FCFA)',
                'value' => 1587,
            ],
            [
                'label' => 'Bilan (millions FCFA)',
                'value' => 3917,
            ],
            [
                'label' => 'Résultat net (millions FCFA)',
                'value' => -1172,
            ],
            [
                'label' => 'Dépense (millions FCFA)',
                'value' => 1106,
            ],
            [
                'label' => 'Capital social (millions FCFA)',
                'value' => 3360,
            ],
            [
                'label' => 'Placements financiers (millions FCFA)',
                'value' => null,
            ],
            [
                'label' => 'Revenu (millions FCFA)',
                'value' => null,
            ],
        ];

        foreach ($stats as $statData) {
            Stat::create($statData);
        }
    }
}