<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class SlidesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('slides')->insert([
            [
                'image' => 'public/images_slides/7TBopfgeHdKjoLEPVh5rf3bbJylUeE4gY7UuYUyj.jpg',
                'title' => 'Bienvenue à la Caisse des Dépôts et Consignations',
                'title_en' => null,
                'description' => 'Des services de dépôts et consignations fiables pour votre tranquillité d’esprit.',
                'description_en' => null,
                'order' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'image' => 'public/images_slides/j6vTPcfOr7r4hEbJLIsUTtubwky5xiHcPbzdqcPB.jpg',
                'title' => 'La Banque, les Administrations Publiques',
                'title_en' => null,
                'description' => 'Au coeur de la finance camerounaise.',
                'description_en' => null,
                'order' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'image' => 'public/images_slides/VnFZQzUT2bPKi5i5K3mvmkyLOX9DtEId5q9KU4RT.jpg',
                'title' => 'Sécurisez Vos Économies avec la CDEC Cameroun',
                'title_en' => null,
                'description' => 'Des solutions sur mesure pour la gestion de vos finances personnelles et professionnelles.',
                'description_en' => null,
                'order' => 3,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ]);
    }
}
