<?php

namespace Database\Seeders;

use App\Models\Presentation;
use Illuminate\Database\Seeder;

class PresentationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Presentation::create([
            'description' => '
                <p>La création de la Caisse des Dépôts et Consignations du Cameroun est intervenue dans ce contexte où le Cameroun avait besoin d’un instrument innovant et alternatif à l’endettement public et capable de mobiliser, sécuriser et rentabiliser des ressources complémentaires, pour les orienter vers le financement du développement socio-économique.</p>

                <p>La Caisse des Dépôts et Consignations du Cameroun (CDEC), établissement public à caractère spécial, a ainsi été créée en vertu de la loi n° 2008/003 du 14 avril 2008 régissant les dépôts et consignations. Son organisation a été consacrée par le décret N°2011-105 du 15 avril 2011 portant organisation et fonctionnement de la CDEC. Suivant ces textes organiques, la CDEC a pour mission de recevoir, de conserver et de gérer les sommes et avoirs publics ou privés, conformément aux lois et règlements en vigueur. Elle peut également gérer sous mandat les services spécifiques qui lui sont confiés par l’État ou ses démembrements. Aussi, la CDEC peut concourir au financement du développement du pays, par l’intermédiaire des structures spécialisées, selon les priorités définies par le gouvernement.</p>

                <p>La CDEC est également un outil important de concrétisation de la vision d’un Cameroun émergent à l’horizon 2035, impulsée par le Président de la République, Son Excellence Paul BIYA, et dont la mise en œuvre est lancée depuis 2010 à travers la réalisation des grands projets structurants, dits de première génération, inscrits dans le Document de Stratégie pour la Croissance et l’Emploi (DSCE). L’opérationnalisation de la CDEC intervient à point dans le contexte actuel particulièrement déterminant pour le Cameroun, marqué par:</p>

                <ul>
                    <li>La nécessité de relancer l’économie impactée par diverses crises sécuritaires, sanitaires et économiques.</li>
                    <li>L’accumulation de la dette publique engendrant un risque élevé de surendettement.</li>
                    <li>Le Plan Stratégique Triennal de la CDEC 2023-2025 et le lancement de la deuxième phase de la vision 2035 dans la Stratégie Nationale de Développement 2020-2030 (SND30), pour la transformation structurelle et le développement inclusif du Cameroun.</li>
                </ul>

                <p>L’entrée en scène de la CDEC vient ainsi compléter l’architecture institutionnelle de financement du développement au Cameroun. Celle-ci ambitionne de se positionner comme une institution stratégique, devenir le premier soutien et catalyseur des politiques publiques à travers les stratégies sectorielles et les grands programmes d’infrastructures, et de jouer un rôle central dans la modernisation de l’économie camerounaise. Elle aspire également à l’émergence de nouvelles filières porteuses, avec des effets à l’échelle macroéconomique sur l’emploi, la productivité et la croissance.</p>
            '
        ]);
    }
}
