<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use App\Models\Pays;
use App\Models\Ville;

class PaysTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Lire le fichier JSON
        $json = File::get(database_path('seeders/pays.json'));
        $paysData = json_decode($json, true);

        // Insérer les pays et leurs villes
        foreach ($paysData['pays'] as $paysItem) {
            // Insérer le pays
            $pays = Pays::create([
                'nom' => $paysItem['nom'],
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            // Insérer les villes pour chaque pays
            foreach ($paysItem['villes'] as $villeNom) {
                Ville::create([
                    'nom' => $villeNom,
                    'pays_id' => $pays->id, // Relier la ville au pays correspondant
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
