<?php

namespace Database\Seeders;

use App\Models\Interview;
use App\Models\InterviewDetail;
use Illuminate\Database\Seeder;

class InterviewSeeder extends Seeder
{
    public function run(): void
    {
        // Créer 10 interviews
        Interview::factory(10)->create()->each(function ($interview) {
            // Créer des détails pour chaque interview
            InterviewDetail::factory()->create([
                'interview_id' => $interview->id,
            ]);
        });
    }
}
