<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Carbon;
use App\Models\User;
use App\Models\Administrateur;

class AdministrateursTableSeeder extends Seeder
{
    public function run(): void
    {
        $administrateurs = [
            [
                'name' => 'Admin',
                'email' => 'admin@cdec.cm',
                'password' => 'password123',
                'type_user' => 'administrateur',
            ],
            [
                'name' => 'Admin',
                'email' => 'yohivana794@gmail.com',
                'password' => 'password123',
                'type_user' => 'administrateur',
            ],
            // Autres administrateurs
        ];

        foreach ($administrateurs as $admin) {
            if (User::where('email', $admin['email'])->exists()) {
                continue;
            }

            // Création de l'utilisateur
            $user = User::create([
                'name' => $admin['name'],
                'email' => $admin['email'],
                'password' => Hash::make($admin['password']),
                'type_user' => $admin['type_user'],
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);

            // Création de l'administrateur
            Administrateur::create([
                'user_id' => $user->id,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }
    }
}
