<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('actualite_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('actualite_id')->constrained()->onDelete('cascade'); // Foreign key to actualites table
            $table->string('imagePrincipale')->nullable();
            $table->json('galleryPhotos')->nullable(); // Stores gallery images as a JSON array
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('actualite_details');
    }
};