<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('interview_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('interview_id')->constrained()->onDelete('cascade');
            $table->text('introduction');
            $table->text('introduction_en');
            $table->text('contenu');
            $table->text('contenu_en');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('interview_details');
    }
};
