<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('interviews', function (Blueprint $table) {
            $table->id();
            $table->string('titre')->unique();
            $table->string('titre_en')->unique();
            $table->string('slug')->unique();
            $table->text('description');
            $table->text('description_en');
            $table->date('date');
            $table->string('imagePrincipale');
            $table->string('source');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('interviews');
    }
};