<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reglementations', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('title_en')->nullable(); // Ajout du champ pour la traduction anglaise du titre
            $table->text('description')->nullable();
            $table->text('description_en')->nullable(); // Ajout du champ pour la traduction anglaise de la description
            $table->string('image')->nullable();
            $table->string('document')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('reglementations');
    }
};
