<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSlidesTable extends Migration
{
    public function up()
    {
        Schema::create('slides', function (Blueprint $table) {
            $table->id();
            $table->string('image');
            $table->string('title');
            $table->string('title_en')->nullable(); // Stocke la traduction en anglais
            $table->text('description');
            $table->text('description_en')->nullable(); // Stocke la traduction en anglais
            $table->integer('order')->default(0); // Pour définir l'ordre d'affichage
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('slides');
    }
}
