<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contents', function (Blueprint $table) {
            $table->id();
            $table->string('titre');

            $table->text('Description');

            $table->string('image')->nullable();


            $table->string('video')->nullable();
            // $table->date('datePublication');
            $table->enum('type', ['actualite', 'publication', 'communique', 'interview', 'mediatheque']); // Type de contenu
            $table->foreignId('admin_id')->constrained('administrateurs'); // Ajoutez cette ligne

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contents');
    }
};
