<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('partenaires', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id'); // Référence à l'utilisateur
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->string('nom_entreprise'); // Nom de l'entreprise
            $table->string('nom_dirigeant'); // Nom du dirigeant
            $table->string('email_dirigeant')->unique(); // Email unique du dirigeant
            $table->string('comment_contacter')->nullable(); // Comment contacter (optionnel)
            $table->string('site_web')->nullable(); // Site web (optionnel)

            $table->boolean('est_approuve')->default(false); // Statut d'approbation
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('partenaires');
    }
};
