<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('usagers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id'); // Clé étrangère vers la table users
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->foreignId('pays_id')->constrained('pays')->onDelete('cascade'); // Clé étrangère vers pays
            $table->foreignId('ville_id')->constrained('villes')->onDelete('cascade'); // Clé étrangère vers villes

            $table->string('adresse');
            $table->string('numero_telephone');
            $table->string('numero_fiscal')->unique(); // Numéro fiscal unique
            $table->string('etat_civil'); // État civil (par exemple : célibataire, marié, etc.)
            $table->date('datenaissance'); // Date de naissance
            $table->string('sexe'); // Sexe (par exemple : masculin, féminin)

            $table->string('statut_inscription')->default('en_attente'); // Statut de l'inscription (par exemple : en attente, validée)

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('usagers');
    }
};
