<?php

namespace Database\Factories;

use App\Models\Usager;
use App\Models\User;
use App\Models\Pays;
use App\Models\Ville;
use Illuminate\Database\Eloquent\Factories\Factory;

class UsagerFactory extends Factory
{
    protected $model = Usager::class;

    public function definition(): array
    {
        return [
            'user_id' => User::factory(),
            'adresse' => $this->faker->address,
            'numeroTelephone' => $this->faker->phoneNumber,
            'pays_id' => Pays::factory(),
            'ville_id' => Ville::factory(),
            'etatCivil' => $this->faker->randomElement(['Célibataire', 'Marié', 'Divorcé']),
            'village_id' => null,
            'statut_inscription' => $this->faker->randomElement(['en_attente', 'approuvé', 'rejeté']),
        ];
    }
}
