<?php

namespace Database\Factories;

use App\Models\Partenaire;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class PartenaireFactory extends Factory
{
    protected $model = Partenaire::class;

    public function definition(): array
    {
        return [
            'user_id' => User::factory(),
            'nomEntreprise' => $this->faker->company,
            'nomDirigeant' => $this->faker->name,
            'emailDirigeant' => $this->faker->email,
            'commentContacter' => $this->faker->phoneNumber,
            'siteWeb' => $this->faker->url,
            'estApprouve' => $this->faker->boolean,
        ];
    }
}
