<?php

namespace App\Services;

use Twilio\Rest\Client;

class TwilioService
{
    protected $client;

    public function __construct()
    {
        $sid = env('TWILIO_SID');
        $token = env('TWILIO_AUTH_TOKEN');

        if (!$sid || !$token) {
            throw new \Exception("Twilio credentials are not set in the environment.");
        }

        $this->client = new Client($sid, $token);
    }

    public function sendSms($to, $message)
    {
        return $this->client->messages->create($to, [
            'from' => env('TWILIO_FROM'),
            'body' => $message,
        ]);
    }
}
