<?php

namespace App\Services\Image;

class StringToImageService
{
    /**
     * Extract, validate and decode the image from the string data:image in base64
     *
     * @param string $imageData
     * @return \App\Services\Image\ImageResult
     *
     * @throws \App\Services\Image\HandleImageException
     */
    public static function handle(string $imageData)
    {
        if (preg_match('/^data:image\/(\w+);base64,/', $imageData, $type)) {
            $imageData = substr($imageData, strpos($imageData, ',') + 1);
            $type = strtolower($type[1]);

            if (!in_array($type, ['jpg', 'jpeg', 'png', 'gif'])) {
                throw new HandleImageException('Type d\'image non supporté');
            }

            $imageData = base64_decode($imageData);

            if ($imageData === false) {
                throw new HandleImageException('Décodage Base64 échoué');
            }

            $fileName = uniqid() . '.' . $type;

            return new ImageResult(
                $fileName,
                $imageData
            );
        }
    }
}
