<?php

namespace App\Services\Image;

class ImageResult
{
    protected $file_name;

    protected $file_content;

    public function __construct(string $fileName, string $fileContent)
    {
        $this->file_name = $fileName;

        $this->file_content = $fileContent;
    }

    public function getFileName()
    {
        return $this->file_name;
    }

    public function getFileContent()
    {
        return $this->file_content;
    }

    public function toArray()
    {
        return [
            $this->file_name,
            $this->file_content
        ];
    }
}
