<?php

namespace App\Notifications;

namespace App\Notifications;

use App\Models\Participant;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Carbon\Carbon;

class NewParticipantNotification extends Notification
{
    use Queueable;

    protected $participant; // Store the participant data

    /**
     * Create a new notification instance.
     *
     * @param Participant $participant
     */
    public function __construct(Participant $participant)
    {
        $this->participant = $participant; // Initialize the participant
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail']; // Specify that the notification will be sent via email
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return MailMessage
     */
    public function toMail($notifiable)
    {
        // Calculer le temps écoulé depuis l'inscription
        $inscriptionDate = Carbon::parse($this->participant->date_inscription);
        $timeElapsed = $inscriptionDate->diffForHumans(Carbon::now());

        return (new MailMessage)
            ->subject('Nouveau Participant Inscrit') // Sujet de l'email
            ->greeting('Bonjour Administrateur,') // Salutation
            ->line('Un nouveau participant s\'est inscrit au congrès.') // Message principal
            ->line('Nom: ' . $this->participant->user->name) // Nom du participant
            ->line('Email: ' . $this->participant->user->email) // Email du participant
            ->line('Inscription il y a: ' . $timeElapsed) // Afficher le temps écoulé depuis l\'inscription
            ->action('Voir les Détails', url('/participants/' . $this->participant->id)) // Bouton d\'action
            ->line('Merci de votre attention!'); // Message de fin
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'participant_id' => $this->participant->id, // Store participant ID
            'participant_name' => $this->participant->user->name, // Store participant name
            'time_elapsed' => $this->participant->date_inscription->diffForHumans(), // Store time elapsed
        ];
    }
}
