<?php



namespace App\Notifications;

use App\Models\Contact;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class ContactReceived extends Notification
{
    use Queueable;

    protected $contact;

    public function __construct($contact)
    {
        $this->contact = $contact;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail']; // Utilisez 'database' si vous souhaitez également stocker dans la base de données
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Nouveau Message de Contact')
            ->greeting('Bonjour !') 
            ->line('Vous avez reçu un nouveau message de contact.')
            ->line('Nom: ' . $this->contact->name)
            ->line('Email: ' . $this->contact->email)
            ->line('Message: ' . $this->contact->message)
            ->line('Sujet: ' . $this->contact->subject) 
            ->action('Voir le Message', url('/contacts'))
            ->line('Merci de votre attention!')
            ->salutation('Cordialement,');
    }
}
