<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stichoza\GoogleTranslate\GoogleTranslate;

class Video extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'title_en',
        'youtube_id',
        'date',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($video) {
            if (!$video->title_en && $video->title) {
                $translator = new GoogleTranslate();
                $translator->setSource('fr');
                $translator->setTarget('en');
                $video->title_en = $translator->translate($video->title);
            }
        });
    }
}
