<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * Les attributs qui peuvent être assignés en masse.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'type_user',
    ];

    /**
     * Les attributs qui doivent être cachés lors de la sérialisation.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Les attributs qui doivent être castés.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed', // Hachage automatique du mot de passe
    ];

    /**
     * Relation avec le modèle Usager.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function usager()
    {
        return $this->hasOne(Usager::class);
    }

    /**
     * Relation avec le modèle Partenaire.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function partenaire()
    {
        return $this->hasOne(Partenaire::class);
    }

    /**
     * Relation avec le modèle Administrateur.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function administrateur()
    {
        return $this->hasOne(Administrateur::class);
    }

    /**
     * Vérifie si l'utilisateur est un usager.
     *
     * @return bool
     */
    public function isUsager()
    {
        return $this->type_user === 'usager';
    }

    /**
     * Vérifie si l'utilisateur est un partenaire.
     *
     * @return bool
     */
    public function isPartenaire()
    {
        return $this->type_user === 'partenaire';
    }

    /**
     * Vérifie si l'utilisateur est un administrateur.
     *
     * @return bool
     */
    public function isAdministrateur()
    {
        return $this->type_user === 'administrateur';
    }
}
