<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Usager extends Model
{
    use HasFactory;

    /**
     * Les attributs pouvant être assignés en masse.
     */
    protected $fillable = [
        'user_id',
        'adresse',
        'numero_telephone',
        'numero_fiscal',
        'datenaissance',
        'sexe',
        'pays_id',
        'ville_id',
        'etat_civil',

        'statut_inscription',
    ];

    /**
     * Relation avec le modèle User (Utilisateur).
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Relation avec le modèle Pays.
     */
    public function pays(): BelongsTo
    {
        return $this->belongsTo(Pays::class);
    }

    /**
     * Relation avec le modèle Ville.
     */
    public function ville(): BelongsTo
    {
        return $this->belongsTo(Ville::class);
    }
}
