<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stichoza\GoogleTranslate\GoogleTranslate;

class Stat extends Model
{
    use HasFactory;

    protected $fillable = [
        'label',
        'label_en',
        'value',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($stat) {
            // Auto-translate label to English when creating
            if (!$stat->label_en && $stat->label) {
                $translator = new GoogleTranslate();
                $translator->setSource('fr');
                $translator->setTarget('en');
                $stat->label_en = $translator->translate($stat->label);
            }
        });
    }
}