<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stichoza\GoogleTranslate\GoogleTranslate;

class Sponsor extends Model
{
    use HasFactory;

    protected $fillable = [
        'nom',
        'nom_en',
        'description',
        'description_en',
        'image',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($sponsor) {
            // Auto-translate nom to English when creating
            if (!$sponsor->nom_en && $sponsor->nom) {
                $translator = new GoogleTranslate();
                $translator->setSource('fr');
                $translator->setTarget('en');
                $sponsor->nom_en = $translator->translate($sponsor->nom);
            }

            // Auto-translate description to English when creating
            if (!$sponsor->description_en && $sponsor->description) {
                $translator = new GoogleTranslate();
                $translator->setSource('fr');
                $translator->setTarget('en');
                $sponsor->description_en = $translator->translate($sponsor->description);
            }
        });
    }
}