<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stichoza\GoogleTranslate\GoogleTranslate;

class Slide extends Model
{
    use HasFactory;

    protected $fillable = ['title', 'title_en', 'description', 'description_en', 'image', 'order'];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($slide) {
            $translator = new GoogleTranslate('en');
            $translator->setSource('fr');

            $slide->title_en = $translator->translate($slide->title);
            $slide->description_en = $translator->translate($slide->description);
        });

        static::updating(function ($slide) {
            $translator = new GoogleTranslate('en');
            $translator->setSource('fr');

            $slide->title_en = $translator->translate($slide->title);
            $slide->description_en = $translator->translate($slide->description);
        });
    }
}
