<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stichoza\GoogleTranslate\GoogleTranslate;

class Reglementation extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'title_en', // Ajout du champ pour la traduction anglaise du titre
        'description',
        'description_en', // Ajout du champ pour la traduction anglaise de la description
        'image',
        'document',
    ];

    protected static function boot()
    {
        parent::boot();

        // Traduction automatique lors de la création
        static::creating(function ($reglementation) {
            $translator = new GoogleTranslate('en'); // Traduire vers l'anglais
            $translator->setSource('fr');

            // Traduction du titre
            if ($reglementation->title) {
                $reglementation->title_en = $translator->translate($reglementation->title);
            }

            // Traduction de la description
            if ($reglementation->description) {
                $reglementation->description_en = $translator->translate($reglementation->description);
            }
        });

        // Traduction automatique lors de la mise à jour
        static::updating(function ($reglementation) {
            $translator = new GoogleTranslate('en'); // Traduire vers l'anglais
            $translator->setSource('fr');

            // Traduction du titre si il est modifié
            if ($reglementation->isDirty('title')) {
                $reglementation->title_en = $translator->translate($reglementation->title);
            }

            // Traduction de la description si elle est modifiée
            if ($reglementation->isDirty('description')) {
                $reglementation->description_en = $translator->translate($reglementation->description);
            }
        });
    }
}