<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stichoza\GoogleTranslate\GoogleTranslate;

class Publication extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'title_en', // Ajout du champ pour la traduction anglaise du titre
        'description',
        'description_en', // Ajout du champ pour la traduction anglaise de la description
        'photo',
        'document',
        'publication_date',
    ];

    protected static function boot()
    {
        parent::boot();

        // Traduction automatique lors de la création
        static::creating(function ($publication) {
            $translator = new GoogleTranslate('en'); // Traduire vers l'anglais
            $translator->setSource('fr');

            // Traduction du titre
            if ($publication->title) {
                $publication->title_en = $translator->translate($publication->title);
            }

            // Traduction de la description
            if ($publication->description) {
                $publication->description_en = $translator->translate($publication->description);
            }
        });

        // Traduction automatique lors de la mise à jour
        static::updating(function ($publication) {
            $translator = new GoogleTranslate('en'); // Traduire vers l'anglais
            $translator->setSource('fr');

            // Traduction du titre si il est modifié
            if ($publication->isDirty('title')) {
                $publication->title_en = $translator->translate($publication->title);
            }

            // Traduction de la description si elle est modifiée
            if ($publication->isDirty('description')) {
                $publication->description_en = $translator->translate($publication->description);
            }
        });
    }
}
