<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stichoza\GoogleTranslate\GoogleTranslate;

class Presentation extends Model
{
    use HasFactory;

    protected $fillable = ['description', 'description_en'];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($presentation) {
            $translator = new GoogleTranslate('en'); // Traduction en anglais
            $translator->setSource('fr'); 
            $presentation->description_en = $translator->translate($presentation->description);
        });

        static::updating(function ($presentation) {
            $translator = new GoogleTranslate('en'); // Traduction en anglais
            $translator->setSource('fr'); 
            $presentation->description_en = $translator->translate($presentation->description);
        });
    }
}
