<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Partenaire extends Model
{
    use HasFactory;

    /**
     * Les attributs pouvant être assignés en masse.
     */
    protected $fillable = [
        'user_id',
        'nom_entreprise',
        'nom_dirigeant',
        'email_dirigeant',
        'comment_contacter',
        'site_web',
        'est_approuve',
    ];

    /**
     * Relation avec le modèle User.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
