<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stichoza\GoogleTranslate\GoogleTranslate;

class Mission extends Model
{
    use HasFactory;

    protected $fillable = ['titre', 'titre_en'];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($mission) {
            $translator = new GoogleTranslate('en'); // Traduire vers l'anglais
            $translator->setSource('fr');
            $mission->titre_en = $translator->translate($mission->titre);
        });
    }
}
