<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stichoza\GoogleTranslate\GoogleTranslate;

class InterviewDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'interview_id',
        'introduction',
        'introduction_en',
        'contenu',
        'contenu_en',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($detail) {
            // Auto-translate fields if English versions are not provided
            if (!$detail->introduction_en) {
                $translator = new GoogleTranslate();
                $translator->setSource('fr');
                $translator->setTarget('en');
                $detail->introduction_en = $translator->translate($detail->introduction);
            }

            if (!$detail->contenu_en) {
                $translator = new GoogleTranslate();
                $translator->setSource('fr');
                $translator->setTarget('en');
                $detail->contenu_en = $translator->translate($detail->contenu);
            }
        });
    }

    public function interview()
    {
        return $this->belongsTo(Interview::class);
    }
}