<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use App\Traits\HasImage;
use Stichoza\GoogleTranslate\GoogleTranslate;

class Interview extends Model
{
    use HasFactory, HasImage;

    protected $fillable = [
        'titre',
        'titre_en',
        'slug',
        'description',
        'description_en',
        'date',
        'imagePrincipale',
        'source',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($interview) {
            if (empty($interview->slug)) {
                $interview->slug = Str::slug($interview->titre);
            }

            // Auto-translate fields if English versions are not provided
            if (!$interview->titre_en) {
                $translator = new GoogleTranslate();
                $translator->setSource('fr');
                $translator->setTarget('en');
                $interview->titre_en = $translator->translate($interview->titre);
            }

            if (!$interview->description_en) {
                $translator = new GoogleTranslate();
                $translator->setSource('fr');
                $translator->setTarget('en');
                $interview->description_en = $translator->translate($interview->description);
            }
        });
    }

    public function details()
    {
        return $this->hasOne(InterviewDetail::class);
    }
}