<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stichoza\GoogleTranslate\GoogleTranslate;

class Domaine extends Model
{
    use HasFactory;

    protected $fillable = ['nom', 'nom_en'];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($domaine) {
            $translator = new GoogleTranslate('en');
            $translator->setSource('fr');
            $domaine->nom_en = $translator->translate($domaine->nom);
        });

        static::updating(function ($domaine) {
            $translator = new GoogleTranslate('en');
            $translator->setSource('fr');
            $domaine->nom_en = $translator->translate($domaine->nom);
        });
    }
}
