<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Content extends Model
{
    use HasFactory;

    protected $fillable = [
        'titre',
        'Description',
        'image',
        'video',
        'type',
        'admin_id',
    ];

     // Relation avec le modèle Administrateur
     public function administrateur(): BelongsTo
     {
         return $this->belongsTo(Administrateur::class, 'admin_id');
     }
}

