<?php

namespace App\Models\Concerns;

use Illuminate\Support\Facades\Storage;

trait HasImage
{
    /**
     * Get the URL of the image.
     *
     * @return string|null
     */
    public function getImageUrlAttribute()
    {
        return $this->image ? Storage::url($this->image) : null;
    }

    /**
     * Delete the image from storage.
     *
     * @return void
     */
    public function deleteImage()
    {
        if ($this->image) {
            Storage::delete($this->image);
        }
    }
}
