<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Stichoza\GoogleTranslate\GoogleTranslate;

class Communication extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'title_en', // Ajout du champ pour la traduction anglaise du titre
        'description',
        'description_en', // Ajout du champ pour la traduction anglaise de la description
        'photo',
        'document',
        'communication_date',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($communication) {
            $translator = new GoogleTranslate('en'); // Traduire vers l'anglais
            $translator->setSource('fr');

            // Traduction du titre
            if ($communication->title) {
                $communication->title_en = $translator->translate($communication->title);
            }

            // Traduction de la description
            if ($communication->description) {
                $communication->description_en = $translator->translate($communication->description);
            }
        });

        static::updating(function ($communication) {
            $translator = new GoogleTranslate('en'); // Traduire vers l'anglais
            $translator->setSource('fr');

            // Traduction du titre si il est modifié
            if ($communication->isDirty('title')) {
                $communication->title_en = $translator->translate($communication->title);
            }

            // Traduction de la description si elle est modifiée
            if ($communication->isDirty('description')) {
                $communication->description_en = $translator->translate($communication->description);
            }
        });
    }
}
