<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Administrateur extends Model
{
    use HasFactory;

    protected $table = 'administrateurs';

    protected $fillable = [
        'user_id',
    ];

    // Relation avec le modèle User
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Relation avec le modèle Actualite
    // public function actualites(): HasMany
    // {
    //     return $this->hasMany(Actualite::class, 'admin_id');
    // }
/**
     * Relation one-to-many avec le modèle Content
     */
    public function contents(): HasMany
    {
        return $this->hasMany(Content::class, 'admin_id'); // Un administrateur a plusieurs contenus
    }


}
