<?php
namespace App\Mail;

use App\Models\Participant;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WelcomeParticipantMail extends Mailable
{
    use Queueable, SerializesModels;

    public $participant;
    public $qrCodePath;

    public function __construct(Participant $participant, $qrCodePath)
    {
        $this->participant = $participant;
        $this->qrCodePath = $qrCodePath;
    }

    public function build()
    {
        return $this->view('emails.welcome_participant')
                    ->attach($this->qrCodePath, [
                        'as' => 'ticket.svg',
                        'mime' => 'image/svg+xml',
                    ]);
    }
}
