<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;

class UserController extends Controller
{
    // Récupérer tous les utilisateurs
    public function index()
    {
        $users = User::all(); // Utilisation explicite du modèle User
        return response()->json([
            'message' => 'Liste des utilisateurs récupérée avec succès.',
            'data' => $users,
        ], 200);
    }

    // Récupérer les utilisateurs par type et le total
    public function getByType($type)
    {
        // Vérifier si le type est valide
        if (!in_array($type, ['Usager', 'partenaire', 'administrateur'])) {
            return response()->json([
                'message' => 'Type d\'utilisateur invalide.',
            ], 400);
        }

        $users = User::where('type_user', $type)->get(); // Récupérer les utilisateurs par type
        $total = $users->count(); // Compter le nombre d'utilisateurs

        return response()->json([
            'message' => 'Liste des utilisateurs récupérée avec succès.',
            'total' => $total,
            'data' => $users,
        ], 200);
    }
}