<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Validator;
use App\Models\Subscriber;

class SubscriberController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $subscribers = Subscriber::all();
        return response()->json(['data' => $subscribers], Response::HTTP_OK);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email|unique:subscribers,email|max:255',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

        $subscriber = Subscriber::create($request->all());
        return response()->json(['data' => $subscriber, 'message' => 'Abonné créé avec succès'], Response::HTTP_CREATED);
    }

    /**
     * Display the specified resource.
     */
    public function show(Subscriber $subscriber)
    {
        return response()->json(['data' => $subscriber], Response::HTTP_OK);
    }

    /**
     * Update the specified resource in storage.
     *
     * Note: Dans ce contexte (newsletter), la modification d'un email est rare.
     *        Si vous l'implémentez, soyez prudent et considérez une confirmation par email.
     */
    public function update(Request $request, Subscriber $subscriber)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email|unique:subscribers,email,'.$subscriber->id.'|max:255',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], Response::HTTP_UNPROCESSABLE_ENTITY);
        }

        $subscriber->update($request->all());
        return response()->json(['data' => $subscriber, 'message' => 'Abonné mis à jour avec succès'], Response::HTTP_OK);
    }

    /**
     * Remove the specified resource from storage.
     *
     * Supprimer un abonné (désinscription).
     */
    public function destroy(Subscriber $subscriber)
    {
        $subscriber->delete();
        return response()->json(['message' => 'Abonné supprimé avec succès'], Response::HTTP_OK);
    }
}