<?php
namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Pays;
use Illuminate\Http\Request;

class PaysController extends Controller
{
    public function index(Request $request)
    {
        $search = $request->input('search');
        $pays = Pays::when($search, function ($query) use ($search) {
            return $query->where('nom', 'like', "%{$search}%");
        })->get();

        return response()->json(['status' => 'success', 'data' => $pays], 200);
    }

    // Autres méthodes pour créer, afficher, mettre à jour et supprimer un pays
    public function store(Request $request)
    {
        $request->validate([
            'nom' => 'required|string|max:255',
        ]);

        $pays = Pays::create($request->all());

        return response()->json([
            'status' => 'success',
            'data' => $pays,
            'message' => 'Pays créé avec succès.'
        ], 201);
    }

    public function show(string $id)
    {
        $pays = Pays::find($id);

        if (!$pays) {
            return response()->json([
                'status' => 'error',
                'message' => 'Pays non trouvé.'
            ], 404);
        }

        return response()->json([
            'status' => 'success',
            'data' => $pays,
            'message' => 'Détails du pays récupérés avec succès.'
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        $pays = Pays::find($id);

        if (!$pays) {
            return response()->json([
                'status' => 'error',
                'message' => 'Pays non trouvé.'
            ], 404);
        }

        $request->validate([
            'nom' => 'required|string|max:255',
        ]);

        $pays->update($request->all());

        return response()->json([
            'status' => 'success',
            'data' => $pays,
            'message' => 'Pays mis à jour avec succès.'
        ], 200);
    }

    public function destroy(string $id)
    {
        $pays = Pays::find($id);

        if (!$pays) {
            return response()->json([
                'status' => 'error',
                'message' => 'Pays non trouvé.'
            ], 404);
        }

        $pays->delete();

        return response()->json([
            'status' => 'success',
            'message' => 'Pays supprimé avec succès.'
        ], 200);
    }
}
