<?php
namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Participant;
use Illuminate\Http\Request;

class ParticipantController extends Controller
{
    public function show($id)
    {
        $participant = Participant::with(['user', 'pays', 'ville', 'village', 'activites', 'themes'])
            ->findOrFail($id);

        return response()->json($participant);
    }

    // public function update(Request $request, $id)
    // {
    //     $participant = Participant::findOrFail($id);

    //     $validatedData = $request->validate([
    //         'adresse' => 'sometimes|string',
    //         'numeroTelephone' => 'sometimes|string',
    //         'pays_id' => 'sometimes|exists:pays,id',
    //         'ville_id' => 'sometimes|exists:villes,id',
    //         'etatCivil' => 'sometimes|string',
    //         'estMembreAssociation' => 'sometimes|boolean',
    //         'estCantonNonParlant' => 'sometimes|boolean',
    //         'estConferencier' => 'sometimes|boolean',
    //         'village_id' => 'sometimes|exists:villages,id',
    //         'activites' => 'sometimes|array',
    //         'activites.*' => 'exists:activites,id',
    //         'themes' => 'sometimes|array',
    //         'themes.*' => 'exists:themes,id'
    //     ]);

    //     $participant->update($validatedData);

    //     if ($request->has('activites')) {
    //         $activitesData = array _fill_keys($request->input('activites'), ['dateInscription' => now()]);
    //         $participant->activites()->sync($activitesData);
    //     }

    //     if ($request->has('themes')) {
    //         $participant->themes()->sync($request->input('themes'));
    //     }

    //     return response()->json([
    //         'message' => 'Mise à jour réussie'
    //     ]);
    // }
}
