<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Usager;
use App\Models\Partenaire;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;








class AuthController extends Controller


{
    /**
     * Créer un utilisateur
     */
    private function createUser (array $data, string $typeUser )
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
            'type_user' => $typeUser ,
        ]);
    }

    /**
     * Enregistrement d'un usager
     */
    public function registerUsager(Request $request)
    {
        try {
            // Validation des données d'entrée
            $validatedData = $request->validate([
                'name' => 'required|string|max:255',
                'email' => 'required|string|email|max:255|unique:users',
                'password' => 'required|string|min:8|confirmed',
                'adresse' => 'required|string',
                'datenaissance' => 'required|date',
    'sexe' => 'required|string|in:masculin,feminin',
                'numero_telephone' => 'required|string',
                'numero_fiscal' => 'required|string',
                'pays_id' => 'required|exists:pays,id',
                'ville_id' => 'required|exists:villes,id',
                'etat_civil' => 'required|string',
            ]);

            // Créer l'utilisateur
            $user = $this->createUser ($validatedData, 'Usager');

            // Créer l'usager
            $usager = Usager::create([
                'user_id' => $user->id,
                'adresse' => $validatedData['adresse'],
                'numero_telephone' => $validatedData['numero_telephone'],
                'numero_fiscal' => $validatedData['numero_fiscal'],
                'pays_id' => $validatedData['pays_id'],
                'ville_id' => $validatedData['ville_id'],
                'etat_civil' => $validatedData['etat_civil'],
             'datenaissance' => $validatedData['datenaissance'],
              'sexe' => $validatedData['sexe'],

                'statut_inscription' => 'Inscription réussie',
            ]);

            return response()->json([
                'message' => 'Inscription réussie.',
                'usager' => $usager,
            ], 201);

        } catch (ValidationException $e) {
            return response()->json([
                'message' => 'Validation échouée',
                'errors' => $e->validator->errors()
            ], 422);

        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Une erreur est survenue lors de l\'inscription',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Enregistrement d'un partenaire
     */
    public function registerPartenaire(Request $request)
    {
        try {
            // Validation des données d'entrée
            $validatedData = $request->validate([
                'name' => 'required|string|max:255',
                'email' => 'required|string|email|max:255|unique:users',
                'password' => 'required|string|min:8|confirmed',
                'nom_entreprise' => 'required|string',
                'nom_dirigeant' => 'required|string',
                'email_dirigeant' => 'required|string|email|max:255|unique:partenaires',
            ]);

            // Créer l'utilisateur
            $user = $this->createUser ($validatedData, 'partenaire');

            // Créer le partenaire
            $partenaire = Partenaire::create([
                'user_id' => $user->id,
                'nom_entreprise' => $validatedData['nom_entreprise'],
                'nom_dirigeant' => $validatedData['nom_dirigeant'],
                'email_dirigeant' => $validatedData['email_dirigeant'],
            ]);

            return response()->json([
                'message' => 'Inscription réussie.',
                'partenaire' => $partenaire,
            ], 201);

        } catch (ValidationException $e) {
            return response()->json([
                'message' => 'Validation échouée',
                'errors' => $e->validator->errors()
            ], 422);

        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Une erreur est survenue lors de l\'inscription',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Récupérer les informations de l'utilisateur connecté
     */
    public function me(Request $request)
    {
        $user = $request->user(); // Récupération de l'utilisateur connecté
        return response()->json([
            'message' => 'Informations de l\'utilisateur récupérées avec succès.',
            'data' => $user,
        ], 200);
    }

    // Login pour tous les utilisateurs
public function login(Request $request)
{
    $request->validate([
        'email' => 'required|string|email',
        'password' => 'required|string',
    ]);

    // Vérifier les informations d'identification
    $credentials = $request->only('email', 'password');

    // Authentifier l'utilisateur
    if (Auth::attempt($credentials)) {
        $user = Auth::user(); // Récupération de l'utilisateur authentifié

        // Créer un token
        $token = $user->createToken('auth_token')->plainTextToken;

        // Message de succès de la connexion, avec confirmation du type d'utilisateur
        return response()->json([
            'message' => 'Connexion réussie.',
            'access_token' => $token,
            'token_type' => 'Bearer',
            'type_user' => $user->type_user, // Ajouter type_user pour confirmation
        ], 200);
    }

    return response()->json(['message' => 'Identifiants non valides.'], 401);
}
    /**
     * Déconnexion de l'utilisateur (invalidation du token)
     */
    public function logout()
    {
        $user = Auth::user();
        \Log::info('User  logging out', ['user_id' => $user->id]);

        $user->tokens()->delete();

        return response()->json(['message' => 'Déconnexion réussie']);
    }
}
